Imports System
Imports System.Collections

'
' defines a marker interface for use by the LinkedList class
'

Public Interface EqualByIdentity
End Interface 'EqualByIdentity

'
' implements a linked list, and uses marker interface
' to decide equality test
'
<Serializable()> _
Public Class LinkedList
    Private store As New ArrayList()

    '
    ' Find an object in a linked list that is equal to the given
    ' object. Equality is normally determined by calling the given
    ' object's Equals method.  However, if the given object implements
    ' the EqualByIdentity interface, then equality will be determined
    ' by the = operator.
    '
    Public Function Find(ByVal o As Object) As LinkedList
        If o Is Nothing Or TypeOf o Is EqualByIdentity Then
            Return findEq(o)
        End If
        Return findEquals(o)
    End Function 'Find


    '
    ' Find an object in a linked list that is equal to the given
    ' object. Equality is determined by the == operator.
    '
    Function findEq(ByVal o As Object) As LinkedList
        Dim x As Object
        For Each x In store
            If x = o Then
                Return CType(x, LinkedList)
            End If
        Next x
        Return Nothing
    End Function 'findEq

    '
    ' Find an object in a linked list that is equal to the given
    ' object. Equality is determined by calling the given
    ' object's equals method.
    '
    Function findEquals(ByVal o As Object) As LinkedList
        Dim x As Object
        For Each x In store
            If x.Equals(o) Then
                Return CType(x, LinkedList)
            End If
        Next x
        Return Nothing
    End Function 'findEquals
End Class 'LinkedList 
